
from sklearn import mixture
import scipy.stats as stats
import numpy as np
import pandas as pd

clusters=( np.array([0, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 15, 18])) ,(np.array([4, 19])),(np.array([13])),(np.array([1, 14, 16, 17]) )

def compute_prob(x, weights, means, covars, clusters=clusters):
	""" computes the posterior probabilities of each galaxy belonging to each of the 4 activity classes """
	gamma=np.zeros(4)
	for cl in range(4):
		for dist in clusters[cl]:
			gamma[cl]+= weights[dist] * stats.multivariate_normal.pdf(x, means[dist], covars[dist])
	gamma /= np.sum(gamma)
	return gamma
	

def svm_classification_4d(x, svc_4d_coef, svc_4d_inter):
	""" estimates the activity class of a galaxy using the surfaces from the 4-dimesional SVM """
	if (surface1_4d(x, svc_4d_coef, svc_4d_inter)>0) &(surface2_4d(x, svc_4d_coef, svc_4d_inter)>0) &(surface3_4d(x, svc_4d_coef, svc_4d_inter)>0):
		return 0
	elif (surface1_4d(x, svc_4d_coef, svc_4d_inter)<0) &(surface4_4d(x, svc_4d_coef, svc_4d_inter)>0) &(surface5_4d(x, svc_4d_coef, svc_4d_inter)>0):
		return 1
	elif (surface2_4d(x, svc_4d_coef, svc_4d_inter)<0) &(surface4_4d(x, svc_4d_coef, svc_4d_inter)<0) &(surface6_4d(x, svc_4d_coef, svc_4d_inter)>0):
		return 2
	elif (surface3_4d(x, svc_4d_coef, svc_4d_inter)<0) &(surface5_4d(x, svc_4d_coef, svc_4d_inter)<0) &(surface6_4d(x, svc_4d_coef, svc_4d_inter)<0):
		return 3
	else:
		return 5



def svm_classification_3d(x, svc_3d_coef, svc_3d_inter):
	""" estimates the activity class of a galaxy using the surfaces from the 3-dimesional SVM """
	if (surface1_3d(x, svc_3d_coef, svc_3d_inter)>0) &(surface2_3d(x, svc_3d_coef, svc_3d_inter)>0) &(surface3_3d(x, svc_3d_coef, svc_3d_inter)>0):
		return 0
	elif (surface1_3d(x, svc_3d_coef, svc_3d_inter)<0) &(surface4_3d(x, svc_3d_coef, svc_3d_inter)>0) &(surface5_3d(x, svc_3d_coef, svc_3d_inter)>0):
		return 1
	elif (surface2_3d(x, svc_3d_coef, svc_3d_inter)<0) &(surface4_3d(x, svc_3d_coef, svc_3d_inter)<0) &(surface6_3d(x, svc_3d_coef, svc_3d_inter)>0):
		return 2
	elif (surface3_3d(x, svc_3d_coef, svc_3d_inter)<0) &(surface5_3d(x, svc_3d_coef, svc_3d_inter)<0) &(surface6_3d(x, svc_3d_coef, svc_3d_inter)<0):
		return 3
	else:
		return 5



def surface1_4d(x, svc_4d_coef, svc_4d_inter):
	return np.dot(svc_4d_coef[0,:],x)+svc_4d_inter[0]

def surface2_4d(x, svc_4d_coef, svc_4d_inter):
	return np.dot(svc_4d_coef[1,:],x)+svc_4d_inter[1]

def surface3_4d(x, svc_4d_coef, svc_4d_inter):
	return np.dot(svc_4d_coef[2,:],x)+svc_4d_inter[2]
	
def surface4_4d(x, svc_4d_coef, svc_4d_inter):
	return np.dot(svc_4d_coef[3,:],x)+svc_4d_inter[3]

def surface5_4d(x, svc_4d_coef, svc_4d_inter):
	return np.dot(svc_4d_coef[4,:],x)+svc_4d_inter[4]

def surface6_4d(x, svc_4d_coef, svc_4d_inter):
	return np.dot(svc_4d_coef[5,:],x)+svc_4d_inter[5]
	


def surface1_3d(x, svc_3d_coef, svc_3d_inter):
	return np.dot(svc_3d_coef[0,:],x)+svc_3d_inter[0]

def surface2_3d(x, svc_3d_coef, svc_3d_inter):
	return np.dot(svc_3d_coef[1,:],x)+svc_3d_inter[1]

def surface3_3d(x, svc_3d_coef, svc_3d_inter):
	return np.dot(svc_3d_coef[2,:],x)+svc_3d_inter[2]
	
def surface4_3d(x, svc_3d_coef, svc_3d_inter):
	return np.dot(svc_3d_coef[3,:],x)+svc_3d_inter[3]

def surface5_3d(x, svc_3d_coef, svc_3d_inter):
	return np.dot(svc_3d_coef[4,:],x)+svc_3d_inter[4]

def surface6_3d(x, svc_3d_coef, svc_3d_inter):
	return np.dot(svc_3d_coef[5,:],x)+svc_3d_inter[5]










