C     The array "p" below contains the integration abscissae for Patterson 
C     quadrature on the interval (0,1).  Since the abscissae are symmetric 
C     about 0.5, only the values <= 0.5 are stored.  The array "w" contains 
C     the corresponding integration weights.  Points and weights are stored 
C     in the order used by pquad.  The  data statements for "p" and "w" were 
C     prepared by computer. 

      block data bpw511

      double precision p(0:255), w(0:510)
      common /ppw511/p, w

      integer i

C     new points for the 1 point rule
      data p(0) / 5.0d-1 /

C     new points for the 3 point rule
      data p(1) /
     *1.12701 66537 92583 11482d-1/
      
C     new points for the 7 point rule
      data (p(i),  i=2,3)  /
     *1.97543 65645 98985 82882d-2,  2.82878 12532 65987 20999d-1/
      
C     new points for the 15 point rule
      data (p(i),  i=4,7)  /
     *3.08401 83936 22488 89574d-3,  5.57703 83563 87150 05548d-2,
     *1.89448 52663 13867 98530d-1,  3.88306 65678 55165 59186d-1/
      
C     new points for the 31 point rule
      data (p(i),  i=8,15)  /
     *4.50937 51616 62011 68887d-4,  9.23442 52231 29946 56632d-3,
     *3.51725 71285 12997 16649d-2,  8.16370 30915 56563 22486d-2,
     *1.48751 89675 42364 60695d-1,  2.34340 12817 78121 88014d-1,
     *3.34432 30337 10115 83454d-1,  4.43755 52843 34066 87127d-1/
      
C     new points for the 63 point rule
      data (p(i),  i=16,31)  /
     *6.35559 39821 19403 10216d-5,  1.39687 03138 89020 46177d-3,
     *5.65762 12262 85260 03074d-3,  1.39085 62625 70910 17110d-2,
     *2.68285 70813 29854 74258d-2,  4.48144 21521 49785 37511d-2,
     *6.80460 30903 15476 14268d-2,  9.65297 34024 89119 40718d-2,
     *1.30121 97782 36526 20661d-1,  1.68545 16998 76097 02269d-1,
     *2.11402 14497 39770 92578d-1,  2.58190 98652 70794 86219d-1,
     *3.08320 33790 06348 26542d-1,  3.61125 08898 90878 42467d-1,
     *4.15882 37422 38962 67509d-1,  4.71827 84347 67036 05014d-1/
      
C     new points for the 127 point rule
      data (p(i),  i=32,63)  /
     *8.78482 25542 00709 99393d-6,  2.00600 16404 46583 74016d-4,
     *8.41682 34079 63037 34683d-4,  2.13794 76507 96405 74528d-3,
     *4.25213 94109 46933 80075d-3,  7.31425 02007 39814 44312d-3,
     *1.14292 42680 14714 29218d-2,  1.66810 74220 79171 64539d-2,
     *2.31349 96787 11943 17926d-2,  3.08398 01110 20355 81726d-2,
     *3.98299 87264 99378 96351d-2,  5.01275 50111 52998 16807d-2,
     *6.17432 92757 64736 51292d-2,  7.46777 52615 82486 01211d-2,
     *8.89218 72817 50979 63137d-2,  1.04457 53310 00758 19283d-1,
     *1.21258 01680 97431 81037d-1,  1.39288 45731 49505 42258d-1,
     *1.58506 28445 44603 85956d-1,  1.78861 67874 51202 43113d-1,
     *2.00298 03487 88785 53513d-1,  2.22752 43368 40337 25567d-1,
     *2.46156 12123 31416 98923d-1,  2.70434 99400 50838 33563d-1,
     *2.95510 08938 50556 63795d-1,  3.21298 08108 42339 23812d-1,
     *3.47711 77922 16429 78332d-1,  3.74660 63484 82584 11694d-1,
     *4.02051 24864 44499 23042d-1,  4.29787 88342 37199 12703d-1,
     *4.57772 97995 81445 58145d-1,  4.85907 67552 51271 52830d-1/
      
C     new points for the 255 point rule
      data (p(i),  i=64,95)  /
     *1.20181 01257 67689 88420d-6,  2.80018 96472 81211 80732d-5,
     *1.19754 53778 39763 34776d-4,  3.09830 98748 82090 35960d-4,
     *6.27192 76595 24426 48236d-4,  1.09732 27520 21362 71908d-3,
     *1.74292 70425 54863 07566d-3,  2.58424 85996 89499 74043d-3,
     *3.63932 78586 05692 33590d-3,  4.92431 47996 14920 40973d-3,
     *6.45373 60229 82966 40505d-3,  8.24067 12106 83635 61917d-3,
     *1.02968 59164 56865 80969d-2,  1.26327 70123 79866 61196d-2,
     *1.52576 70248 77038 41145d-2,  1.81796 89215 09393 37395d-2,
     *2.14058 91945 06951 86319d-2,  2.49423 51239 35256 17211d-2,
     *2.87942 17404 45847 00937d-2,  3.29657 81921 13710 60003d-2,
     *3.74605 33546 46217 38179d-2,  4.22812 06422 11747 96780d-2,
     *4.74298 20593 36920 24053d-2,  5.29077 15832 22048 85703d-2,
     *5.87155 79876 32904 65792d-2,  6.48534 72225 94304 70744d-2,
     *7.13208 44556 88392 17374d-2,  7.81165 58663 64569 94808d-2,
     *8.52389 02681 29929 99109d-2,  9.26856 06172 43129 32821d-2,
     *1.00453 85451 95792 99100d-1,  1.08540 30294 08584 91807d-1/
      
      data (p(i),  i=96,127)  /
     *1.16941 09034 81199 54642d-1,  1.25651 85319 15316 98589d-1,
     *1.34667 73937 89093 69335d-1,  1.43983 42231 88739 82707d-1,
     *1.53593 11511 04426 48553d-1,  1.63490 58488 47907 60401d-1,
     *1.73669 16729 49912 51950d-1,  1.84121 78114 44028 84793d-1,
     *1.94840 94314 24067 99922d-1,  2.05818 78277 61687 29283d-1,
     *2.17047 05728 81727 88689d-1,  2.28517 16675 08442 54754d-1,
     *2.40220 16923 12714 89004d-1,  2.52146 79604 06192 69915d-1,
     *2.64287 46706 41705 61533d-1,  2.76632 30616 89857 63129d-1,
     *2.89171 15668 69183 49972d-1,  3.01893 59697 11920 30409d-1,
     *3.14788 95602 49608 84931d-1,  3.27846 32920 02809 88612d-1,
     *3.41054 59396 57616 58409d-1,  3.54402 42574 08766 59018d-1,
     *3.67878 31379 45366 19028d-1,  3.81470 57720 50851 36394d-1,
     *3.95167 38087 84094 02617d-1,  4.08956 75162 03739 00877d-1,
     *4.22826 59425 93109 45654d-1,  4.36764 70781 38490 16575d-1,
     *4.50758 80170 09403 98955d-1,  4.64796 51197 85724 10468d-1,
     *4.78865 41761 73181 98394d-1,  4.92953 05679 46087 68693d-1/
      
C     new points for the 511 point rule
      data (p(i),  i=128,159)  /
     *1.63521 63280 78093 72420d-7,  3.85093 18712 05986 12218d-6,
     *1.66349 50756 86155 85846d-5,  4.34594 27660 85859 99699d-5,
     *8.88181 60106 13040 20564d-5,  1.56856 77584 11341 11918d-4,
     *2.51443 76640 64047 32373d-4,  3.76190 52832 87632 00522d-4,
     *5.34474 58459 47188 82100d-4,  7.29472 15141 60469 86732d-4,
     *9.64182 73753 48383 49069d-4,  1.24144 19682 63800 01738d-3,
     *1.56392 82573 69919 35026d-3,  1.93416 89603 42481 10695d-3,
     *2.35454 84255 94848 86928d-3,  2.82731 78216 38297 03447d-3,
     *3.35460 55741 57516 89468d-3,  3.93842 72345 68441 15871d-3,
     *4.58069 40208 52878 16147d-3,  5.28321 97398 79580 64178d-3,
     *6.04772 61524 37859 76668d-3,  6.87584 70434 96223 65925d-3,
     *7.76913 13355 92732 70180d-3,  8.72904 55744 59697 87471d-3,
     *9.75697 60616 39330 29201d-3,  1.08542 30837 62073 02370d-2,
     *1.20220 41648 99412 34356d-2,  1.32615 65973 74653 66134d-2,
     *1.45738 89133 60377 83720d-2,  1.59600 26491 12002 60182d-2,
     *1.74209 25710 04216 70106d-2,  1.89574 69047 67426 21297d-2/
      
      data (p(i),  i=160,191)  /
     *2.05704 75644 89988 93221d-2,  2.22607 03780 90815 12132d-2,
     *2.40288 53063 71320 52509d-2,  2.58755 66532 93132 14687d-2,
     *2.78014 32657 06667 57047d-2,  2.98069 87213 16513 93148d-2,
     *3.18927 15041 77459 66875d-2,  3.40590 51674 52318 03273d-2,
     *3.63063 84835 23165 15784d-2,  3.86350 55818 32537 92386d-2,
     *4.10453 60750 46124 91818d-2,  4.35375 51742 81470 49602d-2,
     *4.61118 37942 47054 81878d-2,  4.87683 86491 91716 24759d-2,
     *5.15073 23405 84170 48122d-2,  5.43287 34374 34006 41670d-2,
     *5.72326 65501 35749 55370d-2,  6.02191 23986 72186 87162d-2,
     *6.32880 78759 57034 49038d-2,  6.64394 61070 34239 21928d-2,
     *6.96731 65047 85001 50988d-2,  7.29890 48227 26568 70933d-2,
     *7.63869 32054 20955 78097d-2,  7.98666 02369 48477 88249d-2,
     *8.34278 09878 41368 76360d-2,  8.70702 70608 17499 94562d-2,
     *9.07936 66356 03709 63023d-2,  9.45976 45130 92670 28194d-2,
     *9.84818 21590 36565 61091d-2,  1.02445 77747 44497 36610d-1,
     *1.06489 06203 82302 88915d-1,  1.10611 19248 35886 27649d-1/
      
      data (p(i),  i=192,223)  /
     *1.14811 65439 14615 87861d-1,  1.19089 90215 50804 25413d-1,
     *1.23445 35941 47209 28739d-1,  1.27877 41949 43264 58845d-1,
     *1.32385 44584 02542 26168d-1,  1.36968 77246 23051 83657d-1,
     *1.41626 70437 71264 52117d-1,  1.46358 51805 40194 48294d-1,
     *1.51163 46186 31443 83547d-1,  1.56040 75652 60803 37122d-1,
     *1.60989 59556 86777 41081d-1,  1.66009 14577 61251 48917d-1,
     *1.71098 54765 01431 32289d-1,  1.76256 91586 82138 05609d-1,
     *1.81483 33974 47537 52464d-1,  1.86776 88369 41401 26729d-1,
     *1.92136 58769 55036 80993d-1,  1.97561 46775 92078 23340d-1,
     *2.03050 51639 49390 22804d-1,  2.08602 70308 13405 74580d-1,
     *2.14216 97473 71285 83004d-1,  2.19892 25619 36357 79091d-1,
     *2.25627 45066 87352 75696d-1,  2.31421 44024 21024 42009d-1,
     *2.37273 08633 17786 56302d-1,  2.43181 23017 20057 10746d-1,
     *2.49144 69329 23040 60875d-1,  2.55162 27799 77719 22282d-1,
     *2.61232 76785 05854 22358d-1,  2.67354 92815 26826 32071d-1,
     *2.73527 50642 96163 58108d-1,  2.79749 23291 55621 02109d-1/
      
      data (p(i),  i=224,255)  /
     *2.86018 82103 94686 28708d-1,  2.92334 96791 23391 68118d-1,
     *2.98696 35481 56314 53664d-1,  3.05101 64769 07646 02260d-1,
     *3.11549 49762 97203 27599d-1,  3.18038 54136 67251 72365d-1,
     *3.24567 40177 09993 95495d-1,  3.31134 68834 05568 90190d-1,
     *3.37738 99769 70390 72397d-1,  3.44378 91408 15640 99850d-1,
     *3.51053 00985 15710 88282d-1,  3.57759 84597 86372 11252d-1,
     *3.64497 97254 72437 28232d-1,  3.71265 92925 44651 04759d-1,
     *3.78062 24591 05534 89204d-1,  3.84885 44294 03889 11422d-1,
     *3.91734 03188 57636 85959d-1,  3.98606 51590 84676 51222d-1,
     *4.05501 39029 41390 69470d-1,  4.12417 14295 68442 62146d-1,
     *4.19352 25494 43473 71320d-1,  4.26305 20094 40300 29973d-1,
     *4.33274 44978 94191 99328d-1,  4.40258 46496 72799 97433d-1,
     *4.47255 70512 52290 05734d-1,  4.54264 62457 98223 04545d-1,
     *4.61283 67382 50713 58716d-1,  4.68311 30004 13388 55060d-1,
     *4.75345 94760 45656 86642d-1,  4.82386 05859 57794 88370d-1,
     *4.89430 07331 08344 55833d-1,  4.96476 43077 03316 26757d-1/

C     weight for the 1 point rule
      data w(0) / 1d0 /

C     weights on old points for the 3 point rule
      data w(1),  w(2) /
     *4.44444 44444 44444 44444d-1,
C     weights on new points for the 3 point rule
     *2.77777 77777 77777 77778d-1/
      
C     weights on old points for the 7 point rule
      data (w(i),  i=3,6) /
     *2.25458 26932 92370 71173d-1,  1.34244 04493 41667 20364d-1,
      
C     weights on new points for the 7 point rule
     *5.23281 13013 23363 25969d-2,  2.00698 70738 79811 11453d-1/
      
C     weights on old points for the 15 point rule
      data (w(i),  i=7,14) /
     *1.12755 24989 91033 43693d-1,  6.72076 27621 89211 01800d-2,
     *2.58016 41498 53986 98485d-2,  1.00314 26468 84945 10517d-1,
      
C     weights on new points for the 15 point rule
     *8.50085 98149 70130 16951d-3,  4.64635 97657 56226 88429d-2,
     *8.57559 54568 19569 03937d-2,  1.09578 42920 07937 48202d-1/
      
C     weights on old points for the 31 point rule
      data (w(i),  i=15,30) /
     *5.63776 28360 38434 58036d-2,  3.36038 77147 99535 17702d-2,
     *1.29037 99048 08832 67823d-2,  5.01571 39305 89778 93856d-2,
     *4.21728 28696 60553 12316d-3,  2.32314 46630 87899 32707d-2,
     *4.28779 60024 99517 55771d-2,  5.47892 10527 96231 91183d-2,
      
C     weights on new points for the 31 point rule
     *1.27239 03957 80937 20770d-3,  8.22302 49271 93905 46689d-3,
     *1.79785 51653 56466 10484d-2,  2.84897 54747 06167 87061d-2,
     *3.84398 10249 50176 55214d-2,  4.68135 54990 63223 68083d-2,
     *5.28349 46790 11740 48719d-2,  5.59784 36510 47672 84401d-2/
      
      
C     weights on old points for the 63 point rule
      data (w(i),  i=31,62) /
     *2.81888 14180 19235 86938d-2,  1.68019 38574 10386 52709d-2,
     *6.45190 00501 75632 81299d-3,  2.50785 69652 94976 87068d-2,
     *2.10881 52207 79427 41954d-3,  1.16157 23319 95513 47216d-2,
     *2.14389 80012 50386 72465d-2,  2.73946 05263 98143 25161d-2,
     *6.32578 27811 50340 05686d-4,  4.11150 39786 17964 83463d-3,
     *8.98927 57840 64135 16645d-3,  1.42448 77372 91677 43063d-2,
     *1.92199 05124 72776 60193d-2,  2.34067 77495 31400 62013d-2,
     *2.64174 73395 05825 99310d-2,  2.79892 18255 23815 97038d-2,
      
C     weights on new points for the 63 point rule
     *1.81610 74092 27653 29847d-4,  1.28952 48973 42844 13621d-3,
     *3.05775 34110 58623 16984d-3,  5.24912 34548 10660 94914d-3,
     *7.70337 52332 79748 90107d-3,  1.02971 16957 95635 55746d-2,
     *1.29348 39663 60737 34554d-2,  1.55367 75555 84398 24399d-2,
     *1.80322 16390 39128 63201d-2,  2.03577 55058 47215 94669d-2,
     *2.24572 65826 81609 87071d-2,  2.42821 65203 33659 93580d-2,
     *2.57916 26976 02422 93884d-2,  2.69527 49667 63303 19634d-2,
     *2.77407 02178 27968 19939d-2,  2.81388 49915 62715 06363d-2/
      
C     weights on old points for the 127 point rule
      data (w(i),  i=63,94) /
     *1.40944 07090 09617 93469d-2,  8.40096 92870 51932 63543d-3,
     *3.22595 00250 87868 46140d-3,  1.25392 84826 47488 43534d-2,
     *1.05440 76228 63316 43967d-3,  5.80786 16599 77567 36349d-3,
     *1.07194 90006 25193 36232d-2,  1.36973 02631 99071 62581d-2,
     *3.16303 65968 13167 72110d-4,  2.05575 19893 27346 52359d-3,
     *4.49463 78920 32067 86164d-3,  7.12243 86864 58387 15317d-3,
     *9.60995 25623 63883 00966d-3,  1.17033 88747 65700 31007d-2,
     *1.32087 36697 52912 99655d-2,  1.39946 09127 61907 98519d-2,
     *9.03697 82222 69417 89102d-5,  6.44762 04130 52086 96049d-4,
     *1.52887 67050 87765 56807d-3,  2.62456 17274 04429 56257d-3,
     *3.85168 76166 39870 92408d-3,  5.14855 84789 78177 76184d-3,
     *6.46741 98318 03686 72737d-3,  7.76838 77779 21991 21996d-3,
     *9.01610 81951 95643 16003d-3,  1.01788 77529 23607 97335d-2,
     *1.12286 32913 40804 93536d-2,  1.21410 82601 66829 96790d-2,
     *1.28958 13488 01211 46942d-2,  1.34763 74833 81651 59817d-2,
     *1.38703 51089 13984 09970d-2,  1.40694 24957 81357 53181d-2/
      
C     weights on new points for the 127 point rule
      data (w(i),  i=95,126) /
     *2.52680 47603 93125 88123d-5,  1.88873 32316 34923 30137d-4,
     *4.69184 92427 11907 50397d-4,  8.40571 43271 07349 53157d-4,
     *1.28438 24718 97010 18656d-3,  1.78644 63917 58649 82469d-3,
     *2.33552 51860 57160 87370d-3,  2.92172 49379 17819 75378d-3,
     *3.53624 49977 16777 73402d-3,  4.17141 93769 84078 85279d-3,
     *4.82058 88648 51268 34765d-3,  5.47786 66939 18950 82402d-3,
     *6.13791 52800 41385 04348d-3,  6.79578 55048 82773 39479d-3,
     *7.44682 08324 07591 01741d-3,  8.08660 93647 88859 97097d-3,
     *8.71096 50797 32086 87358d-3,  9.31592 41280 69395 09316d-3,
     *9.89774 75240 48749 74401d-3,  1.04529 25722 90601 19261d-2,
     *1.09781 83152 65891 24696d-2,  1.14704 82114 69387 43804d-2,
     *1.19270 26053 01927 00402d-2,  1.23452 62372 24383 84545d-2,
     *1.27228 84982 73238 29063d-2,  1.30578 36688 35304 88402d-2,
     *1.33483 11463 72517 99531d-2,  1.35927 56614 81239 59096d-2,
     *1.37898 74783 24093 65174d-2,  1.39386 25738 30685 08043d-2,
     *1.40382 27896 90862 33034d-2,  1.40881 59516 50830 10653d-2/
      
C     weights on old points for the 255 point rule
      data (w(i),  i=127,158) /
     *7.04720 35450 48089 67346d-3,  4.20048 46435 25966 31772d-3,
     *1.61297 50125 43934 23070d-3,  6.26964 24132 37442 17671d-3,
     *5.27203 81143 16583 86125d-4,  2.90393 08299 88783 68175d-3,
     *5.35974 50031 25966 81161d-3,  6.84865 13159 95358 12903d-3,
     *1.58151 83041 11322 38443d-4,  1.02787 59946 63673 26179d-3,
     *2.24731 89460 16033 93082d-3,  3.56121 93432 29193 57659d-3,
     *4.80497 62811 81941 50483d-3,  5.85169 43738 28501 55033d-3,
     *6.60436 83487 64564 98276d-3,  6.99730 45638 09539 92594d-3,
     *4.51863 67329 37557 46306d-5,  3.22381 02065 28623 89664d-4,
     *7.64438 35254 38827 84191d-4,  1.31228 08637 02214 78128d-3,
     *1.92584 38083 19935 46204d-3,  2.57427 92394 89088 88092d-3,
     *3.23370 99159 01843 36368d-3,  3.88419 38889 60995 60998d-3,
     *4.50805 40975 97821 58001d-3,  5.08943 87646 18039 86674d-3,
     *5.61431 64567 04024 67678d-3,  6.07054 13008 34149 83949d-3,
     *6.44790 67440 06057 34710d-3,  6.73818 74169 08257 99086d-3,
     *6.93517 55445 69920 49848d-3,  7.03471 24789 06787 65907d-3/
      
      data (w(i),  i=159,190) /
     *1.25789 35192 14033 07443d-5,  9.44366 32253 25245 68305d-5,
     *2.34592 46212 39252 04877d-4,  4.20285 71635 53612 31823d-4,
     *6.42191 23594 85050 88403d-4,  8.93223 19587 93249 12341d-4,
     *1.16776 25930 28580 43685d-3,  1.46086 24689 58909 87689d-3,
     *1.76812 24988 58388 86701d-3,  2.08570 96884 92039 42640d-3,
     *2.41029 44324 25634 17382d-3,  2.73893 33469 59475 41201d-3,
     *3.06895 76400 20692 52174d-3,  3.39789 27524 41386 69739d-3,
     *3.72341 04162 03795 50870d-3,  4.04330 46823 94429 98549d-3,
     *4.35548 25398 66043 43679d-3,  4.65796 20640 34697 54658d-3,
     *4.94887 37620 24374 87201d-3,  5.22646 28614 53005 96306d-3,
     *5.48909 15763 29456 23482d-3,  5.73524 10573 46937 19020d-3,
     *5.96351 30265 09635 02011d-3,  6.17263 11861 21919 22727d-3,
     *6.36144 24913 66191 45314d-3,  6.52891 83441 76524 42012d-3,
     *6.67415 57318 62589 97654d-3,  6.79637 83074 06197 95480d-3,
     *6.89493 73916 20468 25872d-3,  6.96931 28691 53425 40213d-3,
     *7.01911 39484 54311 65171d-3,  7.04407 97582 54150 53266d-3/
      
C     weights on new points for the 255 point rule
      data (w(i),  i=191,222) /
     *3.46896 82162 05413 35848d-6,  2.66376 46834 89030 65627d-5,
     *6.78774 55474 61435 98649d-5,  1.24606 20024 14986 47012d-4,
     *1.94872 64223 66411 46608d-4,  2.77147 65746 51873 57459d-4,
     *3.70141 40212 22516 65232d-4,  4.72680 75842 92626 91232d-4,
     *5.83742 05871 49797 03847d-4,  7.02453 99782 75723 21358d-4,
     *8.28056 36407 72263 02608d-4,  9.59856 48550 69362 06261d-4,
     *1.09720 34626 81919 41940d-3,  1.23947 91133 28783 96534d-3,
     *1.38609 78822 96725 49700d-3,  1.53650 92173 51289 16170d-3,
     *1.69019 89955 43460 19117d-3,  1.84668 89585 12825 40913d-3,
     *2.00553 43620 37511 69944d-3,  2.16632 04840 46491 42727d-3,
     *2.32865 86498 78427 38864d-3,  2.49218 22823 82769 30060d-3,
     *2.65654 33025 93528 28314d-3,  2.82140 90506 92222 07923d-3,
     *2.98645 97827 54082 90247d-3,  3.15138 67245 42879 35858d-3,
     *3.31589 06214 50943 94706d-3,  3.47968 07046 95211 46972d-3,
     *3.64247 39902 76903 53194d-3,  3.80399 48328 59528 29161d-3,
     *3.96397 46671 47424 55513d-3,  4.12215 18815 16434 01528d-3/
      
      data (w(i),  i=223,254) /
     *4.27827 17806 53844 80959d-3,  4.43208 66047 41247 13206d-3,
     *4.58335 55817 80394 20335d-3,  4.73184 49969 15032 64714d-3,
     *4.87732 82681 58705 73054d-3,  5.01958 60220 28420 39909d-3,
     *5.15840 61654 73810 84096d-3,  5.29358 39524 42598 96547d-3,
     *5.42492 20446 68657 04951d-3,  5.55223 05670 03463 26850d-3,
     *5.67532 71579 90298 30087d-3,  5.79403 70165 21976 28421d-3,
     *5.90819 29454 15117 88161d-3,  6.01763 53926 39781 31522d-3,
     *6.12221 24908 05992 94931d-3,  6.22178 00953 57017 63157d-3,
     *6.31620 18217 71039 38227d-3,  6.40534 90819 38680 98342d-3,
     *6.48910 11197 68699 64292d-3,  6.56734 50459 80076 41819d-3,
     *6.63997 58719 65265 32519d-3,  6.70689 65425 55049 25648d-3,
     *6.76801 79674 78106 80683d-3,  6.82325 90512 85645 71420d-3,
     *6.87254 67215 00948 31613d-3,  6.91581 59547 53214 33825d-3,
     *6.95300 98006 62730 63177d-3,  6.98407 94032 58469 25786d-3,
     *7.00898 40197 28304 40494d-3,  7.02769 10363 24982 13858d-3,
     *7.04017 59812 76830 66242d-3,  7.04642 25345 80204 17748d-3/
      
C     weights on old points for the 511 point rule
      data (w(i),  i=255,286) /
     *3.52360 17725 24044 83673d-3,  2.10024 23217 62983 15886d-3,
     *8.06487 50627 19671 15351d-4,  3.13482 12066 18721 08835d-3,
     *2.63601 90571 58291 93062d-4,  1.45196 54149 94391 84087d-3,
     *2.67987 25015 62983 40581d-3,  3.42432 56579 97679 06451d-3,
     *7.90759 15205 56612 14618d-5,  5.13937 99733 18366 30896d-4,
     *1.12365 94730 08016 96541d-3,  1.78060 96716 14596 78829d-3,
     *2.40248 81405 90970 75242d-3,  2.92584 71869 14250 77517d-3,
     *3.30218 41743 82282 49138d-3,  3.49865 22819 04769 96297d-3,
     *2.25931 83706 31480 71553d-5,  1.61190 51032 64311 94832d-4,
     *3.82219 17627 19413 92095d-4,  6.56140 43185 11073 90642d-4,
     *9.62921 90415 99677 31021d-4,  1.28713 96197 44544 44046d-3,
     *1.61685 49579 50921 68184d-3,  1.94209 69444 80497 80499d-3,
     *2.25402 70487 98910 79001d-3,  2.54471 93823 09019 93337d-3,
     *2.80715 82283 52012 33839d-3,  3.03527 06504 17074 91975d-3,
     *3.22395 33720 03028 67355d-3,  3.36909 37084 54128 99543d-3,
     *3.46758 77722 84960 24924d-3,  3.51735 62394 53393 82954d-3/
      
      data (w(i),  i=287,318) /
     *6.28963 90944 79637 17627d-6,  4.72183 16126 63527 63533d-5,
     *1.17296 23106 19626 02439d-4,  2.10142 85817 76806 15912d-4,
     *3.21095 61797 42525 44201d-4,  4.46611 59793 96624 56170d-4,
     *5.83881 29651 42902 18426d-4,  7.30431 23447 94549 38445d-4,
     *8.84061 24942 91944 33506d-4,  1.04285 48442 46019 71320d-3,
     *1.20514 72162 12817 08691d-3,  1.36946 66734 79737 70600d-3,
     *1.53447 88200 10346 26087d-3,  1.69894 63762 20693 34870d-3,
     *1.86170 52081 01897 75435d-3,  2.02165 23411 97214 99274d-3,
     *2.17774 12699 33021 71839d-3,  2.32898 10320 17348 77329d-3,
     *2.47443 68810 12187 43600d-3,  2.61323 14307 26502 98153d-3,
     *2.74454 57881 64728 11741d-3,  2.86762 05286 73468 59510d-3,
     *2.98175 65132 54817 51006d-3,  3.08631 55930 60959 61363d-3,
     *3.18072 12456 83095 72657d-3,  3.26445 91720 88262 21006d-3,
     *3.33707 78659 31294 98827d-3,  3.39818 91537 03098 97740d-3,
     *3.44746 86958 10234 12936d-3,  3.48465 64345 76712 70107d-3,
     *3.50955 69742 27155 82586d-3,  3.52203 98791 27075 26633d-3/
      
      data (w(i),  i=319,350) /
     *1.72728 25358 45745 67449d-6,  1.33188 20616 95004 50679d-5,
     *3.39387 27736 69862 08113d-5,  6.23031 00120 74918 42410d-5,
     *9.74363 21118 32057 32660d-5,  1.38573 82873 25936 78729d-4,
     *1.85070 70106 11258 32616d-4,  2.36340 37921 46313 45616d-4,
     *2.91871 02935 74898 51923d-4,  3.51226 99891 37861 60679d-4,
     *4.14028 18203 86131 51304d-4,  4.79928 24275 34681 03131d-4,
     *5.48601 73134 09597 09701d-4,  6.19739 55666 43919 82670d-4,
     *6.93048 94114 83627 48499d-4,  7.68254 60867 56445 80852d-4,
     *8.45099 49777 17300 95587d-4,  9.23344 47925 64127 04564d-4,
     *1.00276 71810 18755 84972d-3,  1.08316 02420 23245 71363d-3,
     *1.16432 93249 39213 69432d-3,  1.24609 11411 91384 65030d-3,
     *1.32827 16512 96764 14157d-3,  1.41070 45253 46111 03961d-3,
     *1.49322 98913 77041 45124d-3,  1.57569 33622 71439 67929d-3,
     *1.65794 53107 25471 97353d-3,  1.73984 03523 47605 73486d-3,
     *1.82123 69951 38451 76597d-3,  1.90199 74164 29764 14580d-3,
     *1.98198 73335 73712 27756d-3,  2.06107 59407 58217 00764d-3/
      
      data (w(i),  i=351,382) /
     *2.13913 58903 26922 40479d-3,  2.21604 33023 70623 56603d-3,
     *2.29167 77908 90197 10168d-3,  2.36592 24984 57516 32357d-3,
     *2.43866 41340 79352 86527d-3,  2.50979 30110 14210 19955d-3,
     *2.57920 30827 36905 42048d-3,  2.64679 19762 21299 48274d-3,
     *2.71246 10223 34328 52476d-3,  2.77611 52835 01731 63425d-3,
     *2.83766 35789 95149 15043d-3,  2.89701 85082 60988 14211d-3,
     *2.95409 64727 07558 94081d-3,  3.00881 76963 19890 65761d-3,
     *3.06110 62454 02996 47466d-3,  3.11089 00476 78508 81579d-3,
     *3.15810 09108 85519 69114d-3,  3.20267 45409 69340 49171d-3,
     *3.24455 05598 84349 82146d-3,  3.28367 25229 90038 20910d-3,
     *3.31998 79359 82632 66259d-3,  3.35344 82712 77524 62824d-3,
     *3.38400 89837 39053 40342d-3,  3.41162 95256 42822 85710d-3,
     *3.43627 33607 50474 15806d-3,  3.45790 79773 76607 16912d-3,
     *3.47650 49003 31365 31588d-3,  3.49203 97016 29234 62893d-3,
     *3.50449 20098 64152 20247d-3,  3.51384 55181 62491 06929d-3,
     *3.52008 79906 38415 33121d-3,  3.52321 12672 90102 08874d-3/
      
C     weights on new points for the 511 point rule
      data (w(i),  i=383,414) /
     *4.72857 96697 50035 24414d-7,  3.68312 03455 11608 34428d-6,
     *9.51068 40952 93790 83397d-6,  1.76875 68602 75947 94314d-5,
     *2.80159 75392 80821 26070d-5,  4.03449 61400 70176 46926d-5,
     *5.45427 72822 87076 10255d-5,  7.04851 51102 05239 57066d-5,
     *8.80633 82772 54159 77372d-5,  1.07184 04501 71084 68574d-4,
     *1.27762 79479 76184 31007d-4,  1.49719 58842 54558 65437d-4,
     *1.72977 24606 49519 35675d-4,  1.97462 06912 34368 52217d-4,
     *2.23104 90505 07016 23744d-4,  2.49841 77665 64002 42259d-4,
     *2.77613 86698 86537 89857d-4,  3.06367 00400 61126 04647d-4,
     *3.36050 88848 00540 97323d-4,  3.66618 27711 23839 56028d-4,
     *3.98024 25864 87754 35753d-4,  4.30225 68890 42639 24064d-4,
     *4.63180 79780 65556 41684d-4,  4.96848 94981 93804 28972d-4,
     *5.31190 52442 67003 56875d-4,  5.66166 88025 79883 24583d-4,
     *6.01740 37000 63298 24404d-4,  6.37874 37988 67347 36723d-4,
     *6.74533 37464 17655 65636d-4,  7.11682 93570 86025 99502d-4,
     *7.49289 78553 22831 81072d-4,  7.87321 79501 60608 30943d-4/
      
      data (w(i),  i=415,446) /
     *8.25747 97385 95728 53276d-4,  8.64538 44527 23080 35838d-4,
     *9.03664 40750 90446 50395d-4,  9.43098 08507 90423 76968d-4,
     *9.82812 67251 57527 38660d-4,  1.02278 22733 99791 46723d-3,
     *1.06298 18370 07362 66522d-3,  1.10338 70945 80016 64597d-3,
     *1.14397 44968 25979 86189d-3,  1.18472 11538 96902 47573d-3,
     *1.22560 47787 52782 41962d-3,  1.26660 36345 39626 62875d-3,
     *1.30769 64863 61180 54613d-3,  1.34886 25576 26472 93333d-3,
     *1.39008 14909 95697 17522d-3,  1.43133 33138 23789 34126d-3,
     *1.47259 84079 09287 91142d-3,  1.51385 74832 90992 72240d-3,
     *1.55509 15557 92137 73079d-3,  1.59628 19279 87173 68395d-3,
     *1.63741 01732 56169 84782d-3,  1.67845 81225 93083 80671d-3,
     *1.71940 78538 43952 95938d-3,  1.76024 16830 67089 61341d-3,
     *1.80094 21577 27662 15934d-3,  1.84149 20514 62019 55983d-3,
     *1.88187 43601 71481 69120d-3,  1.92207 22992 30065 79458d-3,
     *1.96206 93016 14978 87330d-3,  2.00184 90167 92108 44281d-3,
     *2.04139 53102 10789 19175d-3,  2.08069 22632 82548 72882d-3/
      
      data (w(i),  i=447,478) /
     *2.11972 41737 37190 92217d-3,  2.15847 55562 66397 39964d-3,
     *2.19693 11433 80020 97630d-3,  2.23507 58864 13463 63450d-3,
     *2.27289 49566 36066 42744d-3,  2.31037 37464 20403 43741d-3,
     *2.34749 78704 40895 23266d-3,  2.38425 31668 77374 62632d-3,
     *2.42062 56986 05285 67607d-3,  2.45660 17543 59209 48683d-3,
     *2.49216 78498 60515 14957d-3,  2.52731 07289 03250 62529d-3,
     *2.56201 73643 95026 75915d-3,  2.59627 49593 51708 07431d-3,
     *2.63007 09478 46296 55602d-3,  2.66339 29959 13559 28987d-3,
     *2.69622 90024 12777 96803d-3,  2.72856 70998 51549 31998d-3,
     *2.76039 56551 73893 53229d-3,  2.79170 32705 16078 18805d-3,
     *2.82247 87839 33576 84443d-3,  2.85271 12701 02486 66156d-3,
     *2.88239 00409 98555 71477d-3,  2.91150 46465 56740 28851d-3,
     *2.94004 48753 13944 01602d-3,  2.96800 07550 37299 13807d-3,
     *2.99536 25533 40047 35736d-3,  3.02212 07782 86773 17294d-3,
     *3.04826 61789 89443 46462d-3,  3.07378 97461 95418 95107d-3,
     *3.09868 27128 68329 98171d-3,  3.12293 65547 62453 74271d-3/
      
      data (w(i),  i=479,510) /
     *3.14654 29909 90994 18344d-3,  3.16949 39845 88450 82956d-3,
     *3.19178 17430 67068 54898d-3,  3.21339 87189 67187 19461d-3,
     *3.23433 76104 01157 40844d-3,  3.25459 13615 90356 00413d-3,
     *3.27415 31633 94720 32027d-3,  3.29301 64538 34124 68897d-3,
     *3.31117 49186 00842 54729d-3,  3.32862 24915 62273 54109d-3,
     *3.34535 33552 53065 03292d-3,  3.36136 19413 55720 54018d-3,
     *3.37664 29311 68762 64539d-3,  3.39119 12560 61503 73041d-3,
     *3.40500 20979 14473 44187d-3,  3.41807 08895 44556 10920d-3,
     *3.43039 33151 13903 48976d-3,  3.44196 53105 21707 35497d-3,
     *3.45278 30637 77941 77401d-3,  3.46284 30153 58215 77811d-3,
     *3.47214 18585 38912 74719d-3,  3.48067 65397 11832 75747d-3,
     *3.48844 42586 77597 72922d-3,  3.49544 24689 17126 03772d-3,
     *3.50166 88778 40532 86410d-3,  3.50712 14470 12864 58213d-3,
     *3.51179 83923 56129 55515d-3,  3.51569 81843 27143 54754d-3,
     *3.51881 95480 70765 26159d-3,  3.52116 14635 48156 04798d-3,
     *3.52272 31656 39757 38390d-3,  3.52350 41442 22740 06865d-3/

	   end
