; read a rdb table
;
; JaeSub Hong, 2002-2005, version 1.0
; Please report any problem or suggestion at jaesub@head.cfa.harvard.edu
; 
; let's consider only the case that all the comments are in the beginning.
;
;

function rdrdb, filename, $
	noheader=noheader, comment=comment, $
	data=data, sep=sep, struct=struct, recycle=recycle, $
	names=names, units=units

if not keyword_set(sep) then sep='	' ; tab
if not keyword_set(recycle) then recycle=0

line=''
openr, lun, filename, /get_lun
comment=''
if not keyword_set(noheader) then begin
	while (not eof(lun)) do begin
		readf, lun, line
		if strpos(line,'#',0) eq 0 then comment=[comment,line] $
		else goto, found_header
	endwhile
	; no header, no data, nothing
	return, 0

found_header:
;	names = str_sep(line,sep)
	names = strsplit(line,sep,/extract)
	if not eof(lun) then begin
		readf, lun, line
		if strpos(line,'#',0) ne 0 then $
;			units = str_sep(line,sep)
			units = strsplit(line,sep,/extract)
	endif else return, 0
endif

n_field=n_elements(names)
for i=0, n_field-1 do begin
	pos=strpos(names[i],"/",0)
	if pos ge 0 then begin
		names_ = strmid(names[i],0,pos) +'_' + $
			strmid(names[i],pos+1,strlen(names[i])-pos)
		names[i]=names_
	endif
	pos=strpos(names[i],"-",0)
	if pos ge 0 then begin
		names_ = strmid(names[i],0,pos) +'_' + $
			strmid(names[i],pos+1,strlen(names[i])-pos)
		names[i]=names_
	endif
	names[i] = strcompress(names[i],/remove_all)
;	print,names[i]
endfor
;if (recycle eq 0) or (not keyword_set(struct)) then begin
if (not keyword_set(struct)) then begin
	com_str = 'struct=create_struct('
	for i=0, n_field-1 do begin
		if i ne 0 then com_str=com_str+','
		u_unit = strupcase(units[i])
		pos=strpos(u_unit, 'N', 0)
		mode='string' 
		if pos ge 0 then begin
			pos_=strpos(u_unit, 'S', 0)
			if pos_ lt 0 then mode='number' $
			else if pos lt pos_ then mode ='number'
		endif
 		if mode eq 'number' then $
 			com_str=com_str+'"'+names[i]+'",'+'0.0D' $
 		else com_str=com_str+'"'+names[i]+'",'+'""' 

;		if strupcase(strmid(units[i],0,1)) eq 'N' then $
;			com_str=com_str+'"'+names[i]+'",'+'0.0D' $
;		else com_str=com_str+'"'+names[i]+'",'+'""' 
	endfor
	now=execute(com_str+')')
endif 

data=struct
n_field=n_tags(struct)
while (not eof(lun)) do begin
	readf, lun, line
	cur=struct
;	fields = str_sep(line,sep)
	fields = strsplit(line,sep,/extract)
	for i=0, n_field-1 do begin
	; 	print, names[i]
		cur.(i) = fields[i]
	endfor
	data=[data,cur]
endwhile
free_lun,lun

if n_elements(comment) gt 1 then comment=comment[1:*]
n_data= n_elements(data)
if n_data gt 1 then data=data[1:*]
return, n_data-1

end


